% Function: This is the program that calculates the fold change between 
% each entry of two different matrices

% Inputs:
% Matrix_(1/2) - a matrix whose elements are averaged for the output, 
%    primarily from the matrix containing the mean between the two reps 

% Outputs:
% FoldMean - a matrix array of the same dimensions as Matrix_1/2, whose
%    values are the fold change of the entries of the two input matrices
%    (note this output is the fractional fold change and is usually log2
%    transformed afterwards)

function [FoldMatrix] = Fold_Matrix(Matrix_1, Matrix_2)

% determines the size of matrix1 (note matrix 2 needs to be the same size,
% or smaller)
[row,col] = size(Matrix_1);

% initialize and empty matrix
FoldMatrix = zeros(row,col);

% loop over the rows in matix1
parfor i=1:row
    
    % loop over the col in matrix1
    for j=1:col
        
        % calculate the fold change of element in matrix1/matrix2 
        % (note that at this point values less than 1 are fractions that 
        % indicate a negative fold change)
        fold = Matrix_1(i,j)/Matrix_2(i,j);
         
          
        % store the fold change as the division of Matrix1 by Matrix2  
        FoldMatrix(i,j) = fold;
    
    end
    
end
